<?php
class link
{
	private $db;
	private $link_table;
	private $type_table;

	function __construct()
	{
		global $db;
		$this->db=$db;
		$this->link_table=LA_PRE.'link';
		$this->type_table=LA_PRE.'link_type';
	}

	function linklist($status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND name LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->link_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function getlink($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->link_table` WHERE `$this->link_table`.`id`=$id");
	}

	function linkstatis($status=-1)
	{
		global $siteidobj,$_siteid;

		$status=intval($status);

		$where=$_siteid?' siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$status>=0?' AND status='.$status:'';

		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->link_table` WHERE $where");
	}

	function linkset($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getlink($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->link_table,$info,'id='.$id);
				}
			}
		}
		return true;
	}

	function link_delete($ids=array(),$userid)
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getlink($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->mysql_delete($this->link_table,$id);
				}
			}
		}
		return true;
	}

	function admin_link_add($info)
	{
		$info['inputtime']=TIME;
		$info['status']=1;
		$info['siteid']=intval($_SESSION['siteid']);
		return $this->db->insert($this->link_table,$info,true);
	}

	function admin_link_edit($info,$id)
	{
		$info['siteid']=intval($_SESSION['siteid']);
		return $this->db->update($this->link_table,$info,'id='.$id);
	}
	
	function typelist()
	{
		global $page,$_siteid,$siteidobj;
		$moduleid=intval($moduleid);
		$typeid=intval($typeid);

		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;


		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='typeid ASC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=25;
		$result=$datalist->getlist($this->type_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function type_add($info)
	{
		$info['siteid']=intval($_SESSION['siteid']);

		$names=array_map('trim',explode("|",$info['name']));
		foreach($names as $name)
		{
			if($name)
			{
				$info['name']=strip_tags($name);
				$this->db->insert($this->type_table,$info);
			}
		}
		return true;
	}

	function type_delete($id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->typeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$this->db->mysql_delete($this->type_table,intval($id),'typeid');
		return true;
	}

	function gettypeid($moduleid=7)
	{
		$r=$this->db->fetch_one("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." ORDER BY `$this->type_table`.`typeid` ASC");
		return $r?$r['typeid']:0;
	}

	function type_edit($info,$id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->typeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		return $this->db->update($this->type_table,$info,'typeid='.intval($id));
	}

	function typeinfo($id)
	{
		return $this->db->fetch_one("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`typeid`=".intval($id));
	}

	function typename($id)
	{
		$r=$this->typeinfo($id);
		return $r['name'];
	}


	function type_select($moduleid=7,$parentid=0,$g=3)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." ORDER BY `$this->type_table`.`typeid` ASC");
		foreach($r as $_r)
		{
			$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
		}

		return $str;
	}

	function type_select_cat($moduleid=7,$parentid=0)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." ORDER BY `$this->type_table`.`typeid` ASC");
		foreach($r as $_r)
		{
			$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
		}

		return $str;
	}
}
?>